﻿<?php
include 'conexao.php';
session_start();

// Buscar turmas
$turmas = [];
$res = $conn->query("SELECT id, nome, classe, curso, turno FROM turmas ORDER BY nome");
while ($row = $res->fetch_assoc()) {
    $turmas[] = $row;
}

// Verificar se uma turma foi selecionada
$alunos = [];
if (isset($_GET['turma_id'])) {
    $turma_id = intval($_GET['turma_id']);
    
    // Buscar alunos da turma
    $stmt = $conn->prepare("SELECT id, numero, nome, idade, genero FROM alunos WHERE turma_id = ? ORDER BY numero ASC");
    $stmt->bind_param("i", $turma_id);
    $stmt->execute();
    $alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Ver Turmas</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        h2 { margin-top: 40px; }
        .turma-btn {
            padding: 10px 15px;
            margin: 5px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
        }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
        a.nome-link { color: #007BFF; text-decoration: none; }
        a.nome-link:hover { text-decoration: underline; }
    </style>
</head>
<body>

<h1>Selecione uma Turma</h1>
<?php foreach ($turmas as $turma): ?>
    <div style="margin-bottom: 10px;">
        <strong><?= $turma['nome'] . ' ' . $turma['classe'] . ' ' . $turma['curso'] . ' (' . $turma['turno'] . ')' ?></strong><br>
        <a class="turma-btn" href="?turma_id=<?= $turma['id'] ?>">Ver Lista Nominal</a>
        <a class="turma-btn" style="background-color: green;" href="lista_alunos_turma.php?turma_id=<?= $turma['id'] ?>" target="_blank">Imprimir Lista Nominal</a>
    </div>
<?php endforeach; ?>

<?php if ($alunos): ?>
    <h2>Lista de Alunos da Turma</h2>
    <table>
        <thead>
            <tr>
                <th>Nº</th>
                <th>Nome</th>
                <th>Idade</th>
                <th>Género</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($alunos as $aluno): ?>
                <tr>
                    <td><?= $aluno['numero'] ?></td>
                    <td><a class="nome-link" href="editar_aluno.php?id=<?= $aluno['id'] ?>"><?= $aluno['nome'] ?></a></td>
                    <td><?= $aluno['idade'] ?></td>
                    <td><?= $aluno['genero'] ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>


        <div style="text-align: center; margin-top: 20px;">
       <a href="painel_subpedagogico.php" class="btn" style="background: #28a745; margin-left: 10px; text-decoration: none; display: inline-block; padding: 10px 25px; border-radius: 5px; color: white;">Voltar ao Painel</a>
</div>


</body>
</html>
